/*
 * Brickworks
 *
 * Copyright (C) 2023-2025 Orastron Srl unipersonale
 *
 * Brickworks is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * Brickworks is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Brickworks.  If not, see <http://www.gnu.org/licenses/>.
 *
 * File author: Stefano D'Angelo
 */

#include "common.h"
#include <bw_delay.h>

using namespace Brickworks;

typedef struct {
	Delay<>	delay;
	size_t	memSize;
} plugin;

static void plugin_init(plugin *instance, plugin_callbacks *cbs) {
	(void)cbs;
	new(&instance->delay) Delay<>();
}

static void plugin_fini(plugin *instance) {
	instance->delay.~Delay();
}

static void plugin_set_sample_rate(plugin *instance, float sample_rate) {
	instance->delay.setSampleRate(sample_rate, &instance->memSize);
}

static size_t plugin_mem_req(plugin *instance) {
	return instance->memSize;
}

static void plugin_mem_set(plugin *instance, void *mem) {
	instance->delay.memSet(mem);
}

static void plugin_reset(plugin *instance) {
	instance->delay.reset();
}

static void plugin_set_parameter(plugin *instance, size_t index, float value) {
	(void)index;
	instance->delay.setDelay(0.001f * value);
}

static float plugin_get_parameter(plugin *instance, size_t index) {
	(void)instance;
	(void)index;
	return 0.f;
}

static void plugin_process(plugin *instance, const float **inputs, float **outputs, size_t n_samples) {
	instance->delay.process(inputs, outputs, n_samples);
}
